<?php
/********************************************************/
# Page : Database Operation Page 
# Desc : dbtasks class & functions for max lab reports
# Created For : Metrohospitals.com
# Created By : Yamuna V,netBIOS Technologies
# Created On : Monday 28 th June 2010
/********************************************************/

define("DBTASK_EXECUTE_SELECT", 1);
define("DBTASK_EXECUTE_INSERT", 2);
define("DBTASK_EXECUTE_UPDATE", 3);
define("DBTASK_EXECUTE_DELETE", 4);

class dbtasks{

	#Declaaring Private Variables
	private $db   				= DB_DATABASE; #database name from Configuration File
	private $host 				= DB_HOST;	   #HostName from configuration file
	private $user 				= DB_USER;     #Database User
	private $pass 				= DB_PASS;	   #DB Pass
	private $table				= "";
	private $primaryKey			= "";          #Can find by [getPrimaryKey] method
	private $fields	  			= array();	   #Can find by [optimiseFields] method
	private $insert_id			= 0;
	var $indent				=	"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
	var $arrVals			= 	array();
				
	#Constructing the dbtask class	
	function __construct($table){
		$this->connection	= $this->connect();
		$this->table		= $table;
		$this->now 			= date("Y-m-d h:i:s");
		$this->today 		= date("Y-m-d");
	}

	# Error Handling Method for dbtask (database errors from mysql )
	# @param1 => STATUS {0 => stops execution of Page,1 =>  cant produce an output for current method}
	# @param2 => Mysql/Custom Error Number 	

	function getError($string=null){
		echo '<font color="red" size="3">An error occured : </font>'.$string;
		return false;
	}
	
	#Get Table fields as an array
	function optimiseFields(){
	    $conn = $this->connect();
		$result = mysqli_query($conn, "SHOW COLUMNS FROM ".$this->table);
		if (!$result)
		{
			$This->getError(mysqli_error($conn));
		}
		if (mysqli_num_rows($result) > 0)
		{
			$structure = array();
			while ($row = mysqli_fetch_assoc($result))
			{
				$structure[$row['Field']] = '';
			}
		}
		return $structure;
	}

	#Connect To Database 
	function connect(){
		$connection = mysqli_connect($this->host, $this->user, $this->pass)  ;
		if (!$connection) { die ('An error occured :'.mysqli_error());}
		else{
			$dbConnection = mysqli_select_db($connection, $this->db);
			if (!$dbConnection) { 
				$this->getError(mysqli_error($connection));
			}else{
				return $connection;
			}
		}
	}

	# ClearArray :To Clear the repeated Elements from array
	function clearArray($array) 
	{
		if (!is_array($array) || count($array)==0){
			$this->getError("Invalid Arguments Supplied'");
			return false;
		}
		$this->fields		= $this->optimiseFields($table);
		foreach ($array as $key => $val){
			if (!array_key_exists($key, $this->fields))
				unset($array[$key]);
		}
		return $array;
	}

	# GetPrimarykey of the table
	function getPrimaryKey()
	{   $conn = $this->connect();
		$result = mysqli_query($conn, "SHOW COLUMNS FROM ".$this->table);
		if (!$result)
		{
			$this->getError(mysqli_error($conn));
		}
		else
		{
			if (mysqli_num_rows($result) > 0)
			{
				while ($row = mysqli_fetch_assoc($result))
				{
					if ($row['Key'] == 'PRI')
					{
						$primaryKey = $row['Field'];
					}
				}
				return $primaryKey;
			}
		}
	}

	# BuildQuery for various database operations
	# @param1 => Array to be processed
	# @param2 => Different modes:Insert,Update,Delete,Select
	# @param3 => Where Condition
	# param4  => Orderby
	function buildQuery($value = NULL, $mode = DBTASK_EXECUTE_SELECT, $condition = FALSE, $order = FALSE)
    {
        $where  = ($condition) ? " WHERE $condition "       : "";
        $order  = ($order)     ? " ORDER BY $order "    : "";
        switch ($mode) {
            case DBTASK_EXECUTE_SELECT:
				$fields = ($value == NULL) ?  $this->optimiseFields($table) : $value; 
                $select = implode(",", array_keys($fields)); 
				return   "SELECT $select FROM {$this->table} $where $order ";
				break;
            case DBTASK_EXECUTE_UPDATE:
                array_walk($value, "alter");
                $values = implode(", ", array_values($value));
                $mysql  = "UPDATE {$this->table} SET $values $where ";
                return $mysql;
				break;
            case DBTASK_EXECUTE_INSERT:
            	array_walk($value, "alter");
                $values = implode(", ", array_values($value));
                $mysql  = "INSERT INTO {$this->table} SET $values";
                return $mysql; 
				break;
            case DBTASK_EXECUTE_DELETE: 
                return  "DELETE FROM {$this->table} $where ";
				break;
        }
    }
	
	# Execute an Operations
	# @param1 => Array to be processed
	# @param2 => Different modes:Insert,Update,Delete,Select
	# @param3 => Where Condition
	# param4  => Orderby
    function execute($values = NULL, $mode = DBTASK_EXECUTE_INSERT, $where = NULL, $order = NULL)
    {
         $conn = $this->connect();
       if(($mode == DBTASK_EXECUTE_INSERT || $mode==DBTASK_EXECUTE_UPDATE)&&(!is_array($values) || count($values)==0)){
			$this->getError("1","100"); #Custom Message:DATA INPUT ERROR
        }
		if($values){
			//$values = $this->validateUserInput($values);
        	$values = $this->clearArray($values);
		}
	    $sql = $this->buildQuery($values, $mode, $where, $order);# echo $sql;
        $res = $this->query($sql);
        $this->insert_id = mysqli_insert_id($conn);
        return true;
    }

	# MySQL Query
	# @param => SQL 
    function query($sql){
        $conn = $this->connect();
		$res = mysqli_query($conn, $sql) or die (mysqli_error($conn));
		if(!$res){
			$this->getError(mysqli_error($conn));
			return false;
		}
		else
		{
			return $res;
		}
	}

	# Validates User Input Array,$_GET,$_POST,$_REQUEST etc
	# @param1 => Array to be validated 
	function validateUserInput($array)	{
		
		if($array) foreach($array as $key=>$val){

			   # remove all non-printable characters. CR(0a) and LF(0b) and TAB(9) are allowed
			   # this prevents some character re-spacing such as <java\0script>
			   # note that you have to handle splits with \n, \r, and \t later since they *are* allowed in some inputs
			   $val = preg_replace('/([\x00-\x08][\x0b-\x0c][\x0e-\x20])/', '', $val);

			   # straight replacements, the user should never need these since they're normal characters
			   # this prevents like <IMG SRC=&#X40&#X61&#X76&#X61&#X73&#X63&#X72&#X69&#X70&#X74&#X3A&#X61&#X6C&#X65&#X72&#X74&#X28&#X27&#X58&#X53&#X53&#X27&#X29>
			   $search = 'abcdefghijklmnopqrstuvwxyz';
			   $search .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
			   $search .= '1234567890!@#$%^&*()';
			   $search .= '~`";:?+/={}[]-_|\'\\';
			   for ($i = 0; $i < strlen($search); $i++) {
				  # ;? matches the ;, which is optional
				  # 0{0,7} matches any padded zeros, which are optional and go up to 8 chars

				  # &#x0040 @ search for the hex values
				  $val = preg_replace('/(&#[xX]0{0,8}'.dechex(ord($search[$i])).';?)/i', $search[$i], $val); # with a ;
				  # &#00064 @ 0{0,7} matches '0' zero to seven times
				  $val = preg_replace('/(&#0{0,8}'.ord($search[$i]).';?)/', $search[$i], $val); # with a ;
			   }

			   # now the only remaining whitespace attacks are \t, \n, and \r
			   $ra1 = Array('javascript', 'vbscript', 'expression', 'applet', 'meta', 'xml', 'blink', 'link', 'style', 'script', 'embed', 'object', 'iframe', 'frame', 'frameset', 'ilayer', 'layer', 'bgsound', 'title', 'base');
			   $ra2 = Array('onabort', 'onactivate', 'onafterprint', 'onafterupdate', 'onbeforeactivate', 'onbeforecopy', 'onbeforecut', 'onbeforedeactivate', 'onbeforeeditfocus', 'onbeforepaste', 'onbeforeprint', 'onbeforeunload', 'onbeforeupdate', 'onblur', 'onbounce', 'oncellchange', 'onchange', 'onclick', 'oncontextmenu', 'oncontrolselect', 'oncopy', 'oncut', 'ondataavailable', 'ondatasetchanged', 'ondatasetcomplete', 'ondblclick', 'ondeactivate', 'ondrag', 'ondragend', 'ondragenter', 'ondragleave', 'ondragover', 'ondragstart', 'ondrop', 'onerror', 'onerrorupdate', 'onfilterchange', 'onfinish', 'onfocus', 'onfocusin', 'onfocusout', 'onhelp', 'onkeydown', 'onkeypress', 'onkeyup', 'onlayoutcomplete', 'onload', 'onlosecapture', 'onmousedown', 'onmouseenter', 'onmouseleave', 'onmousemove', 'onmouseout', 'onmouseover', 'onmouseup', 'onmousewheel', 'onmove', 'onmoveend', 'onmovestart', 'onpaste', 'onpropertychange', 'onreadystatechange', 'onreset', 'onresize', 'onresizeend', 'onresizestart', 'onrowenter', 'onrowexit', 'onrowsdelete', 'onrowsinserted', 'onscroll', 'onselect', 'onselectionchange', 'onselectstart', 'onstart', 'onstop', 'onsubmit', 'onunload');
			   $ra = array_merge($ra1, $ra2);

			   $found = true; # keep replacing as long as the previous round replaced something
			   while ($found == true) {
				  $val_before = $val;
				  for ($i = 0; $i < sizeof($ra); $i++) {
					 $pattern = '/';
					 for ($j = 0; $j < strlen($ra[$i]); $j++) {
					    if ($j > 0) {
					       $pattern .= '(';
					       $pattern .= '(&#[xX]0{0,8}([9ab]);)';
					       $pattern .= '|';
					       $pattern .= '|(&#0{0,8}([9|10|13]);)';
					       $pattern .= ')*';
					    }
					    $pattern .= $ra[$i][$j];
					 }
					 $pattern .= '/i';
					 $replacement = substr($ra[$i], 0, 2).'<x>'.substr($ra[$i], 2); # add in <> to nerf the tag
					 $val = preg_replace($pattern, $replacement, $val); # filter out the hex tags
					 if ($val_before == $val) {
					    # no replacements were made, so exit the loop
					    $found = false;
					 }
				  }
			   }
			   $ArrVal[$key]	= mysql_real_escape_string($val);
			 }
		return $ArrVal;
	}

	# Insert data into database
	# @param1 => Array to be inserted 
    function insert($array) 
    {
		return $this->execute($array);
	}  

	# Delete data from database
	# @param1 => Condition if Exists  
    function delete($conditon){
		return $this->execute($array = "", DBTASK_EXECUTE_DELETE, $conditon); 
	}

	# Update data into database
	# @param1 => Array to be updated
	# @param2 => Condition 
    function update($array, $condition){
		return $this->execute($array, DBTASK_EXECUTE_UPDATE, $condition);
	}

	# Return MYSQL Insert Id
    function insertId(){
		return $this->insert_id;
	}
    
	#Fetch All Data from the table 
	# @param1 => Conditions
	# @param2 => Order
    function fetchAllData($where = NULL, $order = NULL){   
        $sql    = $this->buildQuery(NULL, DBTASK_EXECUTE_SELECT, $where, $order);
        $query  = $this->query($sql);
        while($array    =   mysqli_fetch_array($query,MYSQL_ASSOC)){
                $res[]  = $array;
        }
        mysqli_free_result($query); 
        return $res;
    }

	# Count the with respect to the condition
	# @param1 => Condition
    function count($where = NULL){
 		$this->primaryKey = ($this->getPrimaryKey()) ? $this->getPrimaryKey() : '*' ;
        $where  = ($where) ? " WHERE $where "       : "";
      	$sql    = "SELECT count({$this->primaryKey}) FROM {$this->table} $where"; 
        $result = $this->query($sql);
        $res 	= mysqli_fetch_row($result);
		mysqli_free_result($result); 
        return $res[0];
    }

    # TO get limited number of fields from multiple rows.
	# @param1 => Fields which we required on result
	# @param2 => Where Condition
    function getFields($fields, $where = NULL, $order = NULL,$group = NULL)
    {
		$fields = ($fields) ? " $fields "            : " * ";
        $where  = ($where) 	? " WHERE $where "       : "" 	;
        $order  = ($order) 	? " ORDER BY $order "    : ""	;
        $group  = ($group) 	? " GROUP BY $group "    : ""	;        
	 	$sql    = "SELECT $fields FROM {$this->table} $where $group $order;";
        $query  = $this->query($sql);
        while($array    =   mysqli_fetch_array($query,MYSQLI_ASSOC)){
                $res[]  = $array;
        }
        mysqli_free_result($query); 
        return $res;
    }

    # TO get single field from multiple rows.
	# @param1 => Field which we required on result
	# @param2 => Where Condition
    function getSingleField($field, $where = NULL)
    {
        $field 	= ($field) ? " $field "             : " * ";
        $where  = ($where) ? " WHERE $where "       : "";
	 	$sql    = "SELECT $field FROM {$this->table} $where $order;";
		$query  = $this->query($sql);
        $array  =   mysqli_fetch_array($query,MYSQLI_NUM);
        mysqli_free_result($query); 
        return $array[0];
    }

    # To get all data from a single row 
	# @param1 => Fetch the full row as per condition on @param2
	# @param2 => Where Condition
    function fetchFullRow($where = NULL){
        $sql    = $this->buildQuery(NULL, DBTASK_EXECUTE_SELECT, $where, NULL);
        $query  = $this->query($sql);
        $array  =   mysqli_fetch_array($query,MYSQLI_ASSOC);
        mysqli_free_result($query); 
        return $array;
    }

    # To get all data from a single row 
	# @param1 => Fetch the full row as per condition on @param2
	# @param2 => Where Condition
	# @param3 => Order of the Query
    function fetchRowFields($fields,$where = NULL, $order = NULL){
        $fields = ($fields) ? " $fields "         : " * ";
        $where  = ($where) ? " WHERE $where "     : "";
        $order  = ($order) ? " ORDER BY $order "  : "";
     	$sql    = "SELECT $fields FROM {$this->table} $where $order;";
        $query  = $this->query($sql);
        $array  = mysqli_fetch_array($query,MYSQLI_ASSOC);
        mysqli_free_result($query); 
        return $array;
    }
	
	# TO get limited number of rows.
	# @param1 => Count starts from
	# @param2 => Number of Counts
	# @param3 => Where Condition
	# @param4 => Order By		
	function getLimit($from, $count=5,$fields = NULL, $where = NULL, $order = NULL) {
		global $db;
		#$sql	= $this->buildQuery($fields, DBTASK_EXECUTE_SELECT, $where, $order);
		$fields = ($fields) ? " $fields "         : " * ";
        $where  = ($where) ? " WHERE $where "     : "";
        $order  = ($order) ? " ORDER BY $order "  : "";
     	$sql    = "SELECT $fields FROM {$this->table} $where $order";
		$sql	.=" LIMIT  $from,$count ";
		$query	= $this->query($sql);
		while($array 	= 	mysqli_fetch_array($query,MYSQLI_ASSOC)){
			$res[]	= $array;
		}
		mysqli_free_result($query); 
		return $res;
	}
	
	# TO get limited number of rows using join query.
	# @param1 => Join Query
	# @param2 => Count Starts From
	# @param3 => Number of Counts
	function limitQuery($sql, $from, $COUNT){
		//$to = $from + $COUNT;
		$sql.=" LIMIT  $from,$COUNT";
		$query	= $this->query($sql);
		while($array 	= 	mysqli_fetch_array($query,MYSQL_ASSOC)){
				$res[]	= $array;
		}
		mysqli_free_result($query); 
		return $res;
	}
	
	# Count the with respect to the condition
	# @param1 => Condition
    function limitCount($sql = NULL){

        $result = $this->query($sql);
        $res 	= mysqli_num_rows($result);
	
        return $res;
    }
    
	# TO Check the the data already exists or not
	# @param1 => Where condition
	function isExist($where = NULL)	{
		$where		= ($where) ? " $where " : "";
		$res  		= $this->count($where);
		if ($res >= 1)
			return true;
		return false;
	}
	
	# Joint query for sigle row
	# @param1 => Join Query
	function joinQueryRow($sql){
		$query	= $this->query($sql);
		$array 	= 	mysqli_fetch_array($query,MYSQLI_ASSOC);
		mysqli_free_result($query); 
		return $array;
	}
	
	# Joint query for Multiple row
	# @param1 => Join Query
	function joinQuery($sql){
		$query	= $this->query($sql);
		while($array 	= 	mysqli_fetch_array($query,MYSQLI_ASSOC)){
			$res[]	= $array;
		}
		mysqli_free_result($query); 
		return $res;
	}
	
	# Select Box 
	function getOptions($strKey, $strVal, $selected = NULL, $where = NULL, $order = NULL, $group = NULL)
	{
		$strOptions = "";
		$res = array();
		$where	= ($where) ? " WHERE $where " 		: "";
		$order	= ($order) ? " ORDER BY $order " 	: "";
		$group	= ($group) ? " GROUP BY $group " 	: "";
		$sql 	= "SELECT $strKey,$strVal AS value FROM {$this->table} $where $group $order;";
		$query	= $this->query($sql);
		while($array 	= 	mysqli_fetch_array($query,MYSQLI_ASSOC)){
				$res[]	= $array;
		}
		mysqli_free_result($query); 
		#if($res)
		foreach ($res as $key => $val){
			$strOptions .= "<option value='{$val[$strKey]}' ".(($val[$strKey] == $selected) ? "selected" : "").">{$val['value']}</option>\r\n";
		}
		return $strOptions;
	}
	
	# File uploading 
    function uploadWithSave($fieldname=null, $filename=null, $path=null, $newfilename=null,$updateId=null,$arrImgType=null){
		$objFiles	= new files();
		$this->primaryKey = $this->getPrimaryKey();
		$path		= DIR_ROOT.$path;
		$chkError	= $objFiles->checkFileType($filename['name'], $filename['size'], $arrImgType);
		if($filename['size'] > 0)
		{
			if($chkError != 1)	{
				$this->getError('Incorect file format');
				return false;
			}
			$newThumbname	= 	$objFiles->setFileName($newfilename, $filename['name']);
			if($newThumbname == '')
			{
				$this->getError('Cannot set filename');
				return false;
			}
			$uploadError	= $objFiles->upload($filename, $path, $newThumbname, true);
			if($uploadError!= 1)
			{
				$this->getError('Canot upload !');
				return false;
			}
			$updateError	=	$this->update(array($fieldname => $newThumbname),$this->primaryKey."='$updateId'");
			if(!$updateError)
			{
				return false;
			}
			else
			{
				return true;
			}

		}
	}
	
	# Delete Image
    function DeleteImage($key,$ImgField,$path){
		$objFiles= new files();
		$this->primaryKey = $this->getPrimaryKey();
		$path = DIR_ROOT.$path;
		$ImgName = $this->getSingleField($ImgField,$this->primaryKey."='$key'");
		$Error= $objFiles->delFiles($path,$ImgName);
		$this->update(array($ImgField=>""),$this->primaryKey."='$key'");
	}	
	
    # Pagination
    function getPageLink($pgNo, $totPage, $url, $count = "5"){	
		$intPre 	= $pgNo - 1;
		$intNex 	= $pgNo + 1;
		$intFirst 	= $pgNo - 5; 
		$intLast 	= $pgNo + 5;
		$strReturn  ="";

		if ($intFirst <= 0){
			$intFirst	= 1;
		}
		
		if ($intLast >= $totPage){
			$intLast	= $totPage;
		}
		
		if ($intPre <= 0){
			$intPre		= 1;
		} 
		else {
			$strReturn	= str_replace("{pgNo}", "$intPre", $url);
			$strReturn	= str_replace("{pgTxt}", "<div class='pagelinkBorder' style='width=50px;'>&nbsp;Previous&nbsp;</div>", $strReturn); #<img src='images/but_prev.gif'  border=0 alt='Previous'>
		}
		
		for ($i = $intFirst; $i <= $intLast; $i++){
			if ($i != $pgNo) {
				$strTemp	= str_replace("{pgNo}", "$i", $url);
				$strReturn	.= str_replace("{pgTxt}", "<div class='pagelinkBorder' style='width:18px;'>&nbsp;$i&nbsp;</div>", $strTemp);
			} else {
				$strReturn	.= "<td align='center' valign='middle' class='activePage' >$i</td>";
			}
		} 
		if ($intNex > $totPage){
			$intNex		= $totPage;
		} else {
			$strTemp	= str_replace("{pgNo}", "$intNex", $url);
			$strReturn .= str_replace("{pgTxt}", "<div class='pagelinkBorder' style='width=50px;'>&nbsp;Next&nbsp;</div>", $strTemp); #<img src='images/but_next.gif'   border=0 alt='Next'>
		}
		return $strReturn;
	}
	# Content editor using Fckeditor
	# @param1 => Textarea name
	# @param2 => Base path
	# @param3 => Content
	# @param4 => Height
	# @param5 => Width
	function ContentEditor($namepair = null, $basepath = null, $content = null,$height=null,$width=null)	{
	    $oFCKeditor = new FCKeditor($namepair,$height,$width) ;
	    $oFCKeditor->BasePath= $basepath . 'class/MetroFckEditor/' ;
		$oFCKeditor->Width	 = ($width) ? $width : '95%';
		$oFCKeditor->Height	 = ($height) ? $height : '95%';
	    $oFCKeditor->Value 	 = $content ;
	    $oFCKeditor->Create() ;            
	}
	
	#8888*********************************
	function getAsArray($id=NULL)
	{
		$this->_getAsArray($id);
		$returnArray	= array();
		$i				= 0;
	
		foreach ($this->arrVals as $val) {
			$strIndent				= "";
			$returnArray[$i]["id"]		= $val["id"];
			$returnArray[$i]["pid"]		= $val["pid"];
			for ($j = 1; $j < $val["level"]; $j++ )
				$strIndent	.= $this->indent;

			$returnArray[$i]["text"]	= $strIndent.$val["text"];
			$returnArray[$i]["status"]	= $val["status"];
			$returnArray[$i]["sub"]		= $val["sub"];
			$returnArray[$i]["url"]		= $val["url"];

			$returnArray[$i]["level"]	= $val["level"];
			
			$i++;
		}
		return $returnArray;
	}	
	
	function _getAsArray($id = 0, $level = 1, $exitLevel = 0)
	{
		if ($exitLevel <> 0 && $level == $exitLevel+1)
		return false;
		$arrGetAll	= $this->fetchAllData("parent_id = '$id' and status='1'", "level");
		if($arrGetAll){
			foreach($arrGetAll as $key => $val) {
				$this->arrVals[$val["page_id"]]["id"] 		= $val["page_id"];
				$this->arrVals[$val["page_id"]]["pid"] 		= $val["parent_id"];
				$this->arrVals[$val["page_id"]]["text"] 	= $val["page_title"];
				$this->arrVals[$val["page_id"]]["status"] 	= $val["status"];
				$this->arrVals[$val["page_id"]]["url"] 	= $val["page_url"];
				$this->arrVals[$val["page_id"]]["level"]	= $level;
				$this->_getAsArray($val["page_id"], $level+1, $exitLevel);
				
			}
		}
		return $this->arrVals;
	}
	#*************************************
	
	
}
# print an array
function pre($array){
	echo "<pre>";
	print_r($array);
	echo "</pre>";
}

# print an array
function pr($array){
	echo "<pre>";
	print_r($array);
	echo "</pre>";
	exit;
}

# alter an array value
function alter(&$val, $key){
	$val = "$key = '$val'";
}

# Filter unwnted characters from string
function clearString($str, $len=255){
	// BLANK LETTERS NUMBERS UNDERSCORE DOT HYPHEN APOSTROPHE AT-SIGN ONLY
	$regex = "/[^ A-Za-z0-9_@\.\-\']/";
	$str = trim($str);
	$str = preg_replace($regex, '', $str);
	$str = substr($str,0,$len);
	return $str;
}
?>
